#class twitch_core::logging::consul
class twitch_core::logging::consul {
  ::rsyslog::snippet{ '44-consul':
    content => template("${module_name}/logging/44-consul.conf.erb")
  }

  logrotate::rule { 'consul_logs':
    ensure        => present,
    path          => '/var/log/consul.log',
    missingok     => true,
    rotate        => 3,
    rotate_every  => 'day',
    compress      => true,
    sharedscripts => true,
    create        => false,
    postrotate    => 'service rsyslog reload',
  }

}
