#class twitch_core::logging::puppet
class twitch_core::logging::puppet {
  ::rsyslog::snippet{ '43-puppet':
    content => template("${module_name}/logging/43-puppet.conf.erb")
  }

  logrotate::rule { 'puppet_agent_logs':
    ensure        => present,
    path          => '/var/log/puppet-agent.log',
    missingok     => true,
    rotate        => 3,
    rotate_every  => 'day',
    compress      => true,
    sharedscripts => true,
    create        => false,
    postrotate    => 'service rsyslog reload',
  }

}
