#class twitch_core::logging::setup
class twitch_core::logging::setup {

  case $facts['operatingsystem'] {
    'Redhat', 'CentOS': {
      $services_owner = 'root'
      $postrotate_rule = 'service rsyslog reload'
      Logrotate::Rule {
        su       => true,
        su_owner => 'root',
        su_group => 'adm',
      }
    }
    'Debian', 'Ubuntu': {
      $services_owner = 'syslog'
      case $facts['lsbdistcodename'] {
        'xenial': {
          $postrotate_rule = 'service rsyslog rotate'
          Logrotate::Rule {
            su       => true,
            su_owner => 'syslog',
            su_group => 'adm',
          }
        }
        default: {
          $postrotate_rule = 'service rsyslog reload'
        }
      }
    }
    default: {
      fail("Module ${module_name} does not support ${facts['operatingsystem']}")
    }
  }

  file { '/var/log/services':
    ensure  => directory,
    owner   => $services_owner,
    group   => 'adm',
    mode    => '0775',
    require => Class['::rsyslog'],
  }


  # Rotate all local3 and local4 logs (application logs)
  logrotate::rule { 'services_log_dir':
    ensure        => present,
    path          => ['/var/log/services/*.log','/var/log/services/*/*.log'],
    missingok     => true,
    rotate        => 3,
    rotate_every  => 'day',
    compress      => true,
    sharedscripts => true,
    create        => false,
    postrotate    => $postrotate_rule,
  }

}
