#class twitch_core::metrics::diamond
class twitch_core::metrics::diamond (
  $graphite_batch_size       = 1,
  $graphite_host             = hiera('twitch_graphite_host'),
  $graphite_port             = 2003,
  $graphite_timeout          = 5,

  # TODO: Move to a diamond::collector model so they can be defined dynamically
  $collect_memcached_metrics = false,
  $memcached_host            = '127.0.0.1',
  $memcached_port            = 11211,

  $collect_cassandra_metrics = false,

  $collect_httpd_metrics     = false,
  $web_name                  = 'default',

  $collect_rabbitmq_metrics  = false,
  $rabbitmq_host             = '127.0.0.1:55672',

  $collect_elasticsearch_metrics = false,
  $elasticsearch_host            = false,
  $elasticsearch_logstash_mode   = false,
  $collect_udp_metrics           = false,
) {

  # Some variables that can be fiddled,
  # but don't really change across hosts
  $aws                       = true
  $diamond_poll_interval     = 10
  if $::lsbdistcodename == 'precise' {
    $diamond_version           = '4.0.57'
  } elsif $::lsbdistcodename == 'xenial' {
    $diamond_version  = '4.0.451-1'
  } else {
    $diamond_version = '4.0.57'
  }



  # live and tmi systems record additional TCP metrics since they're
  # public-facing and occasionally attacked
  if member(['live', 'tmi'], $::twitch_role) {
    $collected_tcp_metrics = [
      'ActiveOpens',
      'ArpFilter',
      'AttemptFails',
      'CurrEstab',
      'DelayedACKLocked',
      'DelayedACKLost',
      'DelayedACKs',
      'EmbryonicRsts',
      'EstabResets',
      'InErrs',
      'InSegs',
      'ListenDrops',
      'ListenOverflows',
      'LockDroppedIcmps',
      'MaxConn',
      'OfoPruned',
      'OutOfWindowIcmps',
      'OutRsts',
      'OutSegs',
      'PAWSActive',
      'PAWSEstab',
      'PAWSPassive',
      'PassiveOpens',
      'PruneCalled',
      'RcvPruned',
      'RetransSegs',
      'RtoAlgorithm',
      'RtoMax',
      'RtoMin',
      'SyncookiesFailed',
      'SyncookiesRecv',
      'SyncookiesSent',
      'TCPAbortFailed',
      'TCPAbortOnClose',
      'TCPAbortOnData',
      'TCPAbortOnLinger',
      'TCPAbortOnMemory',
      'TCPAbortOnSyn',
      'TCPAbortOnTimeout',
      'TCPBacklogDrop',
      'TCPDSACKIgnoredNoUndo',
      'TCPDSACKIgnoredOld',
      'TCPDSACKOfoRecv',
      'TCPDSACKOfoSent',
      'TCPDSACKOldSent',
      'TCPDSACKRecv',
      'TCPDSACKUndo',
      'TCPDirectCopyFromBacklog',
      'TCPDirectCopyFromPrequeue',
      'TCPFACKReorder',
      'TCPFastRetrans',
      'TCPForwardRetrans',
      'TCPFullUndo',
      'TCPHPAcks',
      'TCPHPHits',
      'TCPHPHitsToUser',
      'TCPLoss',
      'TCPLossFailures',
      'TCPLossUndo',
      'TCPLostRetransmit',
      'TCPMemoryPressures',
      'TCPPartialUndo',
      'TCPPrequeueDropped',
      'TCPPrequeued',
      'TCPPureAcks',
      'TCPRcvCollapsed',
      'TCPSACKDiscard',
      'TCPSACKReneging',
      'TCPSACKReorder',
      'TCPSackFailures',
      'TCPSackRecovery',
      'TCPSackRecoveryFail',
      'TCPSchedulerFailed',
      'TCPSlowStartRetrans',
      'TCPTSReorder',
      'TCPTimeouts',
      'TW',
      'TWKilled',
      'TWRecycled',
    ]
  } else {
    $collected_tcp_metrics = [
      'ActiveOpens',
      'AttemptFails',
      'CurrEstab',
      'EstabResets',
      'InErrs',
      'ListenDrops',
      'ListenOverflows',
      'PassiveOpens',
      'RetransSegs',
      'TCPAbortOnMemory',
      'TCPBacklogDrop',
      'TCPFastRetrans',
      'TCPForwardRetrans',
      'TCPLoss',
      'TCPLostRetransmit',
      'TCPSlowStartRetrans',
      'TCPTimeouts',
    ]
  }

  # Don't collect metrics for vagrant (dev) machines
  if ($::vagrant == undef) and ($::lsbdistcodename == 'precise' or $::lsbdistcodename == 'xenial') {

    # Xenial requires one extra package
    if $::lsbdistcodename == 'xenial' {
      # Override the xenial systemd config file so that we don't do DEBUG logging
      file { '/lib/systemd/system/diamond.service':
        ensure  => present,
        owner   => 'root',
        group   => 'root',
        mode    => '0644',
        source  => 'puppet:///modules/twitch_core/metrics/diamond/diamond.service',
        notify  => Exec['diamond_service_reload'],
        before  => Service['diamond'],
      } ->
      exec { 'diamond_service_reload':
        command     => 'systemctl daemon-reload',
        refreshonly => true,
      }
      package { 'python-configobj':
        before => Service['diamond'],
      }
    }
    # Don't need to require that twitch apt repos
    # are setup because it is explicitly ordered that
    # way in twitch_core init
    package { 'diamond':
      ensure  => $diamond_version,
    }

    file { '/etc/diamond/diamond.conf':
      ensure  => present,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/metrics/diamond/diamond.conf.erb"),
      require => Package['diamond'],
      notify  => Service['diamond'],
    }

    service { 'diamond':
      ensure     => 'running',
      enable     => true,
      hasrestart => true,
      hasstatus  => true,
      require    => [
        Package['diamond'],
        File['/etc/diamond/diamond.conf'],
      ],
    }

    if $collect_httpd_metrics {
      file { '/etc/diamond/collectors/HttpdCollector.conf':
        ensure  => present,
        owner   => 'root',
        group   => 'root',
        mode    => '0644',
        content => template("${module_name}/metrics/diamond/HttpdCollector.conf.erb"),
        require => Package['diamond'],
        notify  => Service['diamond'],
      }
    }

    if $collect_rabbitmq_metrics {
      package {'pyrabbit':
        ensure   => 'installed',
        provider => 'pip',
        before   => Service['diamond'],
      }

      file { '/etc/diamond/collectors/RabbitMQCollector.conf':
        ensure  => present,
        owner   => 'root',
        group   => 'root',
        mode    => '0644',
        content => template("${module_name}/metrics/diamond/RabbitMQCollector.conf.erb"),
        require => Package['diamond'],
        notify  => Service['diamond'],
      }
    }

    if $collect_elasticsearch_metrics {
      file { '/etc/diamond/collectors/ElasticSearchCollector.conf':
        ensure  => present,
        owner   => 'root',
        group   => 'root',
        mode    => '0644',
        content => template("${module_name}/metrics/diamond/ElasticSearchCollector.conf.erb"),
        require => Package['diamond'],
        notify  => Service['diamond'],
      }
    }
  }
}
