# twitch_core::network::dhcp
class twitch_core::network::dhcp(
  $rotate = true,
  $timeout = 1,
){
  validate_bool($rotate)
  validate_integer($timeout)
  $use_local_resolver = hiera('twitch_use_local_resolver', false)
  validate_bool($use_local_resolver)
  $exithook_path = '/etc/dhcp/dhclient-exit-hooks.d'

  # Gate this behind debian since the dhclient-exit-hooks.d path isn't
  # on redhat
  if $::ec2_instance_id and $::osfamily == 'Debian' {
    $template_name = 'resolvoptions_ec2.erb'
    file { '/usr/local/bin/ec2-azpref-resolvers':
      ensure => 'present',
      owner  => 'root',
      group  => 'root',
      mode   => '0755',
      source => "puppet:///modules/${module_name}/dhclient/ec2-azpref-resolvers.rb"
    }
    if $use_local_resolver {
      $_rotate = false
      file { "${exithook_path}/ec2-local-options":
        ensure => 'present',
        owner  => 'root',
        group  => 'root',
        mode   => '0644',
        source => "puppet:///modules/${module_name}/dhclient/ec2-local-options",
        #notify => Exec["bash ${exithook_path}/ec2-azpref-resolvers"],
      }
    } else {
      $_rotate = $rotate
    }

    exec { "bash ${exithook_path}/ec2-azpref-resolvers":
      require     => File["${exithook_path}/ec2-azpref-resolvers"],
      refreshonly => true,
      user        => 'root'
    }
    file { "${exithook_path}/ec2-azpref-resolvers":
      ensure => 'present',
      owner  => 'root',
      group  => 'root',
      mode   => '0644',
      source => "puppet:///modules/${module_name}/dhclient/ec2-azpref-resolvers.sh",
#      notify => Exec["bash ${exithook_path}/ec2-azpref-resolvers"],
    }
  } else {
    $template_name = 'resolvoptions.erb'
    $_rotate = $rotate
  }

  $resolvopts_dest = $::osfamily ? {
    'Debian' => '/etc/dhcp/dhclient-exit-hooks.d/resolvoptions',
    'RedHat' => '/etc/dhcp/dhclient-exit-hooks'
  }

  file { $resolvopts_dest:
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    content => template("${module_name}/dhclient/${template_name}")
  }
}
