# Packages required for LDAP authentication
class twitch_core::packages::authentication {
  if $::osfamily == 'Debian' {
    # Support newer libgcrypt package in Xenial 16.04
    $libgcrypt = $::lsbdistcodename ? {
      "xenial" => "libgcrypt20",
      default  => "libgcrypt11"
    }
  }
  $installed_packages = $::osfamily ? {
    'Debian' => [
      'ldap-utils',
      "$libgcrypt",
      'libldap-2.4-2',
      'libnss-db',
      'libnss-ldap',
      'libpam-ldap',
      'libuser',
      'nss-updatedb',
      'unscd',
    ],
    'RedHat' => [
      'openldap',
      'openldap-clients',
      'nss-pam-ldapd',
      'libuser',
      'nscd',
    ],
  }

  package { $installed_packages:
    ensure => 'installed',
  }
}
