# Packages which get installed on every type of system
class twitch_core::packages::common {
  # Install wget via module so we can override versions
  include wget

  $common_packages = [
    'openssl',
    'man-db',
    #"bsd-mailx",
    #"bzip2",
    #"emacs23-nox",
    #"expect",
    #"pbzip2",  # specific to the video system?
  ]

  $distro_packages = $::osfamily ? {
    'Debian' => [
      'vim',
      'git-core',
      'debian-archive-keyring',
      'debian-keyring',
      'debconf-utils',
      'bsd-mailx'
    ],
    'RedHat' => [
      'vim-enhanced',
      'git',
    ],
  }

  $installed_packages = concat($common_packages, $distro_packages)
  package { $installed_packages:
    ensure => 'installed',
  }
}
