#class twitch_core::packages::consul_params - parameters for consul service
class twitch_core::packages::consul_params {

  $version      = '0.6.3' # consul version number
  $package_version      = '2' # consul package version number
  $purge_config = true

  if $::vagrant == '1' {
    $datacenter = 'sfo01'
  } elsif $::ec2_instance_id != '' {
    $datacenter = 'us-west2'
  } else {
    $datacenter = $::twitch_pop
  }

  if ($::ec2_instance_id != '') {
    $ports = {
      # The Serf LAN port is changed in EC2 for legacy reasons
      # Puppet treats all input as strings, so we use addition to force it to
      # use the integer type
      'serf_lan' => 0 + 8306,
    }
  } else {
    $ports = {}
  }

  $start_join = consul_service_fqdn_lookup('consul', {'dc' => $datacenter})

  # Copied from ::consul::params, used to construct download url
  case $::architecture {
    'x86_64', 'amd64': { $arch = 'amd64' }
    'i386':            { $arch = '386'   }
    default:           {
      fail("Unsupported kernel architecture: ${::architecture}")
    }
  }

  $os = downcase($::kernel)

  $regex     = "(\\.${datacenter}|\\.justin\\.tv|\\.twitch\\.tv|\\.twitchtv\\.com)"
  $node_name = regsubst($::fqdn, $regex, '', 'G')

}
