# Configures the default and supported locales
class twitch_core::packages::locales {
  # CentOS does not have (and does not need) locale-gen, the default locale is
  # already en_US.UTF-8.
  if $::osfamily == 'Debian' {
    package { 'locales':
      ensure => installed,
    }

    file { '/etc/default/locale':
      ensure => 'present',
      owner  => 'root',
      group  => 'root',
      mode   => '0644',
      source => "puppet:///modules/${module_name}/locales/default",
      notify => Exec['locale-gen'],
    }

    file { '/var/lib/locales':
      ensure  => directory,
      owner   => 'root',
      group   => 'root',
      mode    => '0755'
    } ->
    file { '/var/lib/locales/supported.d':
      ensure  => directory,
      owner   => 'root',
      group   => 'root',
      mode    => '0755'
    } ->
    file { '/var/lib/locales/supported.d/local':
      ensure  => present,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => file("${module_name}/locales/supported"),
      notify  => Exec['locale-gen'],
    }

    exec { 'locale-gen':
      path        => ['/usr/sbin', '/usr/bin', '/sbin', '/bin'],
      refreshonly => true,
    }
  }
}
