#class twitch_core::packages::mail - installs and configures local mail service
class twitch_core::packages::mail (
  $smtp_relay = 'smtp.internal.justin.tv'
) {

  if $::osfamily == 'Debian' {
    $debconf_string = 'postfix postfix/main_mailer_type select No configuration'
    exec { 'debconf_postfix_postfix/main_mailer_type':
      command => "/bin/echo ${debconf_string} | /usr/bin/debconf-set-selections",
      unless  => "/usr/bin/debconf-get-selections | /bin/grep -E '^${debconf_string}'",
      require => Package['debconf-utils'],
    }
    $postfix_require = Exec['debconf_postfix_postfix/main_mailer_type']
  } else {
    $postfix_require = undef
  }


  package{ 'postfix':
    ensure  => installed,
    require => $postfix_require,
  }

  file{ '/etc/postfix/main.cf':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/packages/mail/postfix-main-client.cf.erb"),
    require => Package['postfix']
  }
}
