# Sets up NRPE so we can do local nagios checks
class twitch_core::packages::nrpe (
  $nagios_servers = [
    '10.1.98.155',   # nagios-5cbdb0.sfo01.justin.tv
    '10.192.137.16', # nagios-demo.dev.us-west2.justin.tv
    '10.23.16.249',  # video-nagios-3d3314.sjc02
    '10.23.4.250',   # video-nagios-914a04.sjc02 (staging)
    '10.192.67.253', # systems-nagios-3c9b85f9
    '10.192.67.137', # web-nagios-af160f6a
    '10.192.66.110', # science-nagios-69160fac
    '10.192.67.128', # data-nagios-68160fad
    '10.192.66.51',  # devtools-nagios-b23b2277
    '10.192.66.119', # neteng-nagios-b33b2276
    '10.192.67.139', # vod-nagios-0484b56bafc0d8f88
  ]
) {

  $allowed_hosts = concat($nagios_servers, ['127.0.0.1'])

  package {'nsca-client':
    ensure => 'installed',
  }

  # If xenial, manually install this pacakge so that core memory checks work
  if $::lsbdistcodename == 'xenial' {
    package { 'libswitch-perl': }
  }

  class {'::nrpe':
    allowed_hosts   => $allowed_hosts,
    dont_blame_nrpe => 1,
  }

  # The nrpe class pops out of this scope, and the packages it installs are only
  # available in epel. We need to manually enforce ordering on those packages,
  # beacuse any ordering defined on the nrpe class itself causes a dependency
  # cycle
  if $::osfamily == 'RedHat' {
    Package['epel-release'] -> Package[$::nrpe::package_name]
  }
}
