# Configures Chrony to manage system clock, and sets the timezone
class twitch_core::packages::ntp (
  $master             = false,
  $chrony_config_keys = $::osfamily ? {
    'Debian' => '/etc/chrony/chrony.keys',
    'RedHat' => '/etc/chrony.keys',
  },
  $chrony_password    = 'DBdPPQ4GzxenBFij3LQz',
  $version            = 'present',
  $max_update_skew    = '10',

  $upstream_ntp_servers = [
    'ntp1.internal.justin.tv',
    'ntp2.internal.justin.tv',
    'ntp3.internal.justin.tv',
    'ntp4.internal.justin.tv',
  ],

  $query_hosts          = hiera('twitch_networks', [])

) {
  # Set the timezone
  class { '::timezone':
    timezone => 'America/Los_Angeles',
  }

  $_servers = sort($upstream_ntp_servers)
  class { '::chrony':
    config_template => "${module_name}/packages/ntp/chrony.conf.erb",
    package_ensure  => $version,
    servers         => $_servers,
    client_allow    => $query_hosts,
  }

  file { $chrony_config_keys:
    ensure  => file,
    owner   => 'root',
    group   => 'root',
    mode    => '0640',
    content => template("${module_name}/packages/ntp/chrony.keys.erb"),
  }

  $_servers_joined = join($_servers, ' ')

  file { '/etc/default/ntpdate':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => join([
        'NTPDATE_USE_NTP_CONF=no',
        "NTPSERVERS='${_servers_joined}'"
    ], "\n")
  }

  file { '/etc/cron.daily/syncrtc':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    source  => "puppet:///modules/${module_name}/ntp/syncrtc.sh",
    require => Class['::chrony'],
  }

  unless ($master) {
    $_ifup_file = $::osfamily ? {
      'Debian' => '/etc/network/if-up.d/chrony',
      'RedHat' => '/etc/sysconfig/network-scripts/ifup-local'
    }
    file { $_ifup_file:
      ensure  => present,
      owner   => 'root',
      group   => 'root',
      mode    => '0755',
      source  => "puppet:///modules/${module_name}/ntp/ifup.sh",
      require => Class['::chrony'],
    }
  }
}
