#class twitch_core::packages::syslog - configures rsyslog
class twitch_core::packages::syslog (
  $remote_server = undef,
  # We have to define this manually, because the default module list for RedHat
  # includes imjournal, which isn't installed by default and we don't really
  # want it anyways.
  $syslog_modules = $::osfamily ? {
    'Debian' => [
      '$ModLoad imuxsock # provides support for local system logging',
      '$ModLoad imklog   # provides kernel logging support (previously done by rklogd)',
      '#$ModLoad immark  # provides --MARK-- message capability',
    ],
    'RedHat' => [
      '$ModLoad imuxsock # provides support for local system logging',
    ],
  },
) {
  case $::osfamily {
    'Debian': {
      case $::lsbdistcodename {
        'xenial': { $_syslog_require = [] } #Use the default rsyslog
        default:  { $_syslog_require = Apt::Source['syslog'] }
      }
    }
    'RedHat': { $_syslog_require = Yumrepo['rsyslog'] }
  }

  class {'::rsyslog':
    run_group => 'adm',  # dynamic log creation seems to not work without this
    modules   => $syslog_modules,
    require   => $_syslog_require,
  }


  # log_remote is false, since we want to customize the filename of the remote
  # logging config to be loaded last.
  class {'::rsyslog::client':
    log_remote => false,
  }

  if $remote_server {
    if ! defined(Package['rsyslog-relp']) {
      package {'rsyslog-relp':
        ensure  => 'latest',
        require => $_syslog_require,
        notify  => Class['rsyslog::service'],
      }
    }
  }
}
