# class twitch_core::packages::sysstat - installs and configures sysstat service
class twitch_core::packages::sysstat (
  $ensure      = 'running',
  $sa1_options = '-S DISK',
  $sa2_options = ''
) {
  package { 'sysstat':
    ensure => installed,
  }

  $sysstat_enable = $ensure ? {
    'stopped' => false,
    default   => true,
  }

  file { '/etc/default/sysstat':
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/packages/sysstat-default.erb"),
    notify  => Service['sysstat'],
    require => Package['sysstat'],
  }

  service { 'sysstat':
    ensure => $ensure,
    enable => $sysstat_enable,
  }
}
