# Packages which are already declared elsewhere, but are needed everywhere
class twitch_core::packages::virtual {

  $common_packages = [
    'curl',
  ]

  $distro_packages = $::osfamily ? {
    'Debian' => [
        'curl',
        'libcurl3',
        'libcurl3-gnutls',
        'libcurl4-openssl-dev',  # also defined in the `passenger` module, but doesn't matter because this wont error out.
        'libssl-dev',
    ],
    'RedHat' => [
    ],
  }

  $installed_packages = concat($common_packages, $distro_packages)
  ensure_packages($installed_packages)
}
