# Configures our internal APT mirrors
class twitch_core::repositories::apt {
  class { '::apt':
    purge => {
      'sources.list'   => true,
      'sources.list.d' => true,
    }
  }

  # Enable HTTPS for apt
  if !defined(Package['apt-transport-https']) {
    package { 'apt-transport-https':
      ensure => present,
    }
  }

  # The apt::ppa resource needs this installed here, otherwise we get dependency
  # cycles.
  if !defined(Package['python-software-properties']) {
    $properties_package = $::lsbdistcodename ? {
      "xenial" => "software-properties-common",
      default => "python-software-properties"
    }
    package { $properties_package: }
  }

  # these are default for ubuntu
  $ubuntu_releases = {
    "ubuntu-${::lsbdistcodename}"           => { release => $::lsbdistcodename },
    "ubuntu-${::lsbdistcodename}-updates"   => { release => "${::lsbdistcodename}-updates" },
    "ubuntu-${::lsbdistcodename}-backports" => { release => "${::lsbdistcodename}-backports" },
    "ubuntu-${::lsbdistcodename}-security"  => { release => "${::lsbdistcodename}-security" }
  }

  # here we use our internal mirror and official repos
  $sources_defaults = {
    location => 'http://us.archive.ubuntu.com/ubuntu',
    repos    => 'main restricted universe multiverse'
  }

  create_resources(apt::source, $ubuntu_releases, $sources_defaults)

  # pin official repos to priority 500
  create_resources(apt::pin, $ubuntu_releases, {priority => 500})

  # Internal Twitch apt mirror
  apt::source { 'twitch':
    location     => 'http://aptly.internal.justin.tv/internal/twitch',
    repos        => 'main',
    include      => {'src' => false},
    architecture => 'amd64',
    key          => {
      'id'     => '2455E3DBF963DE5FC9FE6BCC043D9668938A900E',
      'source' => 'http://aptly.internal.justin.tv/internal/twitch.gpg',
    },
  }

  # nginx ppa 'mirror'
  # TODO (08/15/2016): Hack to make xenial work. Nginx needs to be properly ported.
  if $::lsbdistcodename != 'xenial' {
    apt::source { 'nginx':
      location     => 'http://aptly.internal.justin.tv/internal/nginx',
      repos        => 'main',
      include      => {'src' => false},
      architecture => 'amd64',
      key          => {
        'id'     => '2455E3DBF963DE5FC9FE6BCC043D9668938A900E',
        'source' => 'http://aptly.internal.justin.tv/internal/twitch.gpg',
      }
    }
    # This one we just don't want in xenial at all, lets use default packages
    apt::source {'syslog':
      location     => 'http://ppa.launchpad.net/adiscon/v8-stable/ubuntu',
      repos        => 'main',
      include      => {'src' => false},
      architecture => 'amd64',
      key          => 'AB1C1EF6EDB5746803FE13E00F6DD8135234BF2B',
    }
  }

  # puppetlabs apt repo
  apt::source { 'puppetlabs':
    location     => 'http://apt.puppetlabs.com',
    repos        => 'main dependencies',
    include      => {'src' => false},
    architecture => 'amd64',
    key          => '47B320EB4C7C375AA9DAE1A01054B7A24BD6EC30',
  }

  # If we're using a proxy, the apt::key commands will need to know that.
  $_key_source_options = $::twitch_networking::http_proxy::proxy_ensure ? {
    'present' =>
              "http-proxy=${::twitch_networking::http_proxy::twitch_apt_proxy}",
    default   => undef,
  }

  if $_key_source_options {
    Apt::Key <| |> {
      options => $_key_source_options,
    }
  }
  #


  # We don't set provider expliticly to apt anywhere, so we have to go with a
  # blacklist instead.
  # The first 'name' restriction is because that package is defined inside of
  # apt::ppa, which causes a dependency cycle...

  Exec['apt_update'] ->  Package <|
    title != 'python-software-properties' and
    provider != 'pip' and provider != 'gem' and tag !='virtual'
  |>
}
