# Configures `pip` to use the Twitch PyPI mirror
# We should perform these tasks with the `::python` module if possible
class twitch_core::repositories::python {

  file { '/root/.pip':
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
  }

  $pypi_mirror = 'https://pypi.internal.justin.tv/simple'
  file { '/root/.pip/pip.conf':
    content => template("${module_name}/repositories/python/pip.conf.erb"),
    owner   => 'root',
    group   => 'root',
    require => File['/root/.pip'],
  }

  # Ensure our PyPI mirror is configured before installing any Python packages
  File['/root/.pip/pip.conf'] -> Package <| provider == 'pip' and tag != 'virtual' |>
}
