# Configures `gem` to use the Twitch Ruby mirror
# We should perform these tasks with the `::ruby` module if possible
class twitch_core::repositories::ruby {
  $rubygems_mirror = 'https://rubygems.org/'
  file { '/etc/gemrc':
    content => template("${module_name}/repositories/ruby/gemrc.erb"),
    owner   => 'root',
    group   => 'root',
    mode    => '0644'
  }

  file { '/usr/local/etc/gemrc':
    ensure  => 'link',
    target  => '/etc/gemrc',
    require => File['/etc/gemrc']
  }

  # Ensure our repositories are configured before Ruby packages are installed
  File['/etc/gemrc'] -> Package <| provider == 'gem' and tag != 'virtual' |>
}
