# Configures our internal yum mirrors
class twitch_core::repositories::yum {
  package { 'epel-release':
    ensure => 'installed',
  }

  $rsyslog_key = '/etc/pki/rpm-gpg/RPM-GPG-KEY-Adiscon'
  file { $rsyslog_key:
    ensure => 'file',
    source => "puppet:///modules/${module_name}/yum-gpg/GPG-KEY-Adiscon",
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
  }

  yumrepo {'rsyslog':
    ensure   => 'present',
    descr    => 'Rsyslog - Adiscon CentOS-$releasever - $basearch',
    baseurl  => 'http://rpms.adiscon.com/v8-stable/epel-$releasever/$basearch',
    enabled  => 1,
    gpgcheck => 1,
    gpgkey   => "file://${rsyslog_key}",
    require  => File[$rsyslog_key],
  }

  yumrepo { 'twitch-video':
    baseurl      => 'http://twitch-video-yum-repo.s3-website-us-west-2.amazonaws.com/',
    enabled      => 1,
    gpgcheck     => 0,
    http_caching => 'none',
    descr        => 'Twitch Video El 7 - $basearch',
  }

  Yumrepo <| |> ->
  Package <| provider != 'rpm' |>
}
