# Called in twitch_core if the puppet environment isn't 'production'.
# This is put in a separate class because it needs to run in a stage after main,
# and you can only assign classes to stages, not regular resources like notify.
#
class twitch_core::warning {
  notify { 'dev-warning':
    message => "!!! WARNING !!!\n!!! WARNING !!!\n!!! WARNING !!!\n\
      WARNING: Puppet is running in the '${::environment}' environment, rather than 'production'.\
      To avoid conflicts, automatic puppet runs have been turned off. Run puppet without an environment specified to re-enable.",
  }
}
