class twitch_cyanite::disk inherits twitch_cyanite {

  # This mount is provided when the AMI is launched.
  # It's not what we want, so make sure it gets removed
  mount { "/mnt":
    ensure => 'unmounted',
    atboot => false,
    device => '/dev/xvdb'
  }

  # Create the directory that we want to mount onto
  file { '/mnt/cyanite':
    ensure  => 'directory',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
  }

  # Mount onto the directory. All metric data will live here,
  # since it is SSD storage and very fast to write to.
  mount { '/mnt/cyanite':
    ensure  => 'mounted',
    atboot  => true,
    fstype  => 'xfs',
    device  => '/dev/md0',
    options => 'noatime,nodiratime,nobarrier',
    require => [Mount["/mnt"], File['/mnt/cyanite']]
  }
}
