class twitch_cyanite (
  $cluster_servers,
  $elasticsearch_url,
  $java_package_name  = $twitch_cyanite::params::java_package_name
  ) inherits twitch_cyanite::params {

  require twitch_core
  # Install the proper version of Java (Oracle 8)
  require twitch_cyanite::java
  # Setup ephemeral SSD RAID storage
  require twitch_cyanite::disk

  anchor { "twitch_cyanite::start": }
  # Setup nginx
  class { "twitch_cyanite::nginx": } ->
  # Then install Cyanite + Cassandra
  class { "twitch_cyanite::install": } ->
  # Now configure it all
  class { "twitch_cyanite::config": } ->
  # Launch the services
  class { "twitch_cyanite::service": } ->
  anchor { "twitch_cyanite::end": }

}
