class twitch_cyanite::install inherits twitch_cyanite {

  # required python-related things before proceeding
  require twitch_python::cairo
  require twitch_python::pip::uwsgi
  require twitch_python::pip::graphite_api
  require twitch_python::pip::cyanite_utils

  # Interface between graphite-api and cyanite
  require twitch_python::pip::cyanite

  # Setup a working cassandra installation
  class { "twitch_cassandra":
    manage_java           => false,
    data_file_directories => ['/mnt/cyanite/data'],
    commitlog_directory   => '/mnt/cyanite/commitlog',
    disable_auth          => true,
  }

  # This is the java archive (jar)
  # This will give you a cyanite user and group
  # Twitch_cassandra module needs to go first, because this deb
  # package has a post-install script that creates the schema
  package { "cyanite":
    require => Class['twitch_cassandra']
  }

  # Place to throw Cyanite things
  file { '/opt/cyanite':
    ensure  => directory,
    owner   => 'cyanite',
    group   => 'cyanite',
    mode    => '0755',
    require => Package['cyanite']
  }

  # Directory for cyanite-related PID files
  file { '/opt/cyanite/pids':
    ensure  => 'directory',
    owner   => 'cyanite',
    group   => 'cyanite',
    mode    => '0755',
    require => [Package['cyanite'], File['/opt/cyanite']]
  }

  file { '/opt/cyanite/bin':
    ensure  => 'directory',
    owner   => 'cyanite',
    group   => 'cyanite',
    mode    => '0755',
    require => [Package['cyanite'], File['/opt/cyanite']]
  }

  # Lightweight launcher script for monit (makes a pidfile)
  file { "/opt/cyanite/bin/cyanite.sh":
    ensure  => 'present',
    owner   => 'cyanite',
    group   => 'cyanite',
    mode    => '0755',
    source  => 'puppet:///modules/twitch_cyanite/cyanite.sh',
    require => File['/opt/cyanite/bin']
  }

  # Log file
  file { '/var/log/cyanite.log':
    ensure  => 'present',
    owner   => 'cyanite',
    group   => 'cyanite',
    mode    => '0755',
    require => Package['cyanite']
  }

  file { '/opt/cyanite/bin/cyanite-prune.sh':
    ensure  => 'present',
    owner   => 'cyanite',
    group   => 'cyanite',
    mode    => '0755',
    content => template("${module_name}/cyanite-prune.sh.erb"),
  }

  # Cron job to clean up metrics that haven't been updated in 3 days
  # Note that this uses logic which makes sure it only runs on one server
  cron { 'prune cyanite':
    command   => "/opt/cyanite/bin/cyanite-prune.sh",
    minute    => "1",
    hour      => "1",
    monthday  => "*",
    month     => "*",
  }

  # Create a place where graphite-api can make a socket file
  file { '/opt/cyanite/sock':
    ensure  => 'directory',
    owner   => 'cyanite',
    group   => 'cyanite',
    mode    => '0755',
    require => Package['cyanite']
  }



}
