class twitch_cyanite::nginx inherits twitch_cyanite {

  # Of course, base nginx things need to be configured/installed first
  require twitch_nginx

  # Create vhost that just forwards graphite-api calls to the
  # underlying uWSGI listener (listens on localhost port 3031)
  nginx::resource::vhost { 'graphite.internal.justin.tv':
    listen_port => 80,
    access_log  => "/var/log/nginx/graphite_access.log",
    add_header  => {
      "Access-Control-Allow-Origin"  => "*",
      "Access-Control-Allow-Methods" => '"GET, OPTIONS"',
      "Access-Control-Allow-Headers" => '"origin, authorization, accept"',
    },
    uwsgi       => "unix:////opt/cyanite/sock/uwsgi.sock",
  }

}
