class twitch_cyanite::service inherits twitch_cyanite {

  # uWSGI daemon for graphite-api
  $graphite_api_pidfile = "/opt/cyanite/pids/graphite_api.pid"
  twitch_monit::check { "graphite-api":
    pidfile        => "${graphite_api_pidfile}",
    cwd            => "${graphite_dir}/lib",
    uid            => 'cyanite',
    gid            => 'cyanite',
    check_interval => 5,
    command        => "/usr/local/bin/uwsgi --master --socket /opt/cyanite/sock/uwsgi.sock -b 32768 -p 8 --pidfile ${graphite_api_pidfile} --module graphite_api.app:app --die-on-term --chmod-socket=666",
  }

  # Cyanite service
  $cyanite_pidfile = "/opt/cyanite/pids/cyanite.pid"
  twitch_monit::check { "cyanite":
    pidfile        => "${cyanite_pidfile}",
    cwd            => "/usr",
    uid            => 'cyanite',
    gid            => 'cyanite',
    check_interval => 5,
    command        => "/opt/cyanite/bin/cyanite.sh ${cyanite_pidfile}",
  }

}
