class twitch_dashboard (
  $db_host = 'localhost'
) {
  require twitch_core

  # ubuntu doesn't use /sbin/nologin, symlink it to /bin/false
  file { '/sbin/nologin':
    ensure => link,
    target => '/bin/false',
  }

  # vagrant puts ruby stuff in /opt/vagrant_ruby
  # this is some temporary testing code which is probably no longer needed
  # it may even be specific to my local vagrant environment
  if ($::virtual == "virtualbox") {
    $ruby_symlink = 'mkdir -p /var/lib/gems/1.8 && ln -s /opt/vagrant_ruby/lib/ruby/gems/1.8/gems /var/lib/gems/1.8/gems'
    exec { $ruby_symlink:
      before => Class['dashboard'],
    }
  }

  class { 'dashboard':
    dashboard_password => 'testpassword',
    dashboard_site     => $::fqdn,
    dashboard_port     => 80,
    mysql_root_pw      => 'testpassword',
    passenger          => true,
    host               => $db_host,
    require            => [
      File['/sbin/nologin'],
    ],
  }

  logrotate::rule { 'puppet-dashboard-extras':
    path         => '/usr/share/puppet-dashboard/log/delayed_job.log',
    compress     => true,
    copytruncate => true,
    rotate_every => 'day',
    ifempty      => false,
    missingok    => true,
    rotate       => 5,
    require      => Class['dashboard'],
  }
}
