#!/bin/bash
# Checks to make sure that ElasticSearch has created a snapshot within the last day.

repo_name=$1
snapshot_name=$2

status_lines=$(curl -s localhost:9200/_snapshot/$repo_name/_status?format=yaml | wc -l)
if [ "$status_lines" -gt "3" ]; then
  echo "OK - Snapshot currently running"
  exit 0
fi

snapshots=$(/usr/local/bin/curator --loglevel warning show snapshots --repository $repo_name --newer-than 30 --time-unit hours | grep $snapshot_name | wc -l)
if [ "$snapshots" -gt "0" ]; then
  echo "OK - Found $snapshots snapshots in '$repo_name'"
  exit 0
else
  echo "CRITICAL - Found no snapshots in repository '$repo_name'"
  exit 2
fi
