class twitch_elasticsearch::install inherits twitch_elasticsearch {
  class { 'elasticsearch':
    manage_repo   => true,
    repo_version  => $::twitch_elasticsearch::version,
    config        => $config,
    init_defaults => $init_config,
  }

  elasticsearch::instance { $instance_name:
    datadir   => $datadir,
  }

  # elasticsearch::plugin causes a dependency cycle with ::instance if we
  # separate plugin installation into a plugin.pp file, so we gotta do it here.
  $plugin_defaults = {
    instances => $instance_name,
  }
  create_resources('elasticsearch::plugin', $plugins, $plugin_defaults)
}
