class twitch_elasticsearch::logs (
  $output_tag = $twitch_core::logging::filebeat::output_tag,
) inherits twitch_elasticsearch {
  ::filebeat::prospector { 'elasticsearch':
    paths     => [
      '/var/log/elasticsearch/*/*.log',
    ],
    doc_type  => 'elasticsearch',
    multiline => {
      # ElasticSearch logs multi-exception errors in a weird way, so we match
      # against, eg, "[2016", at the beginning of the, instead of just "["
      pattern => '^\[[0-9]{4}-',
      negate  => true,
      match   => 'after',
    },
    fields   => {
      'output' => $output_tag,
    }
  }
}
