class twitch_glitch () {
  consul::service { 'glitch':
    tags => [$::twitch_environment],
  }

  group { 'glitch':
    ensure => present,
    system => true,
  }

  user { 'glitch':
    ensure     => present,
    gid        => 'glitch',
    groups     => [],
    home       => '/opt/twitch/glitch',
    managehome => true,
    forcelocal => true,
    system     => true,
    require    => [
      Group['glitch'],
      File['/opt/twitch'],
    ],
  }

  python::virtualenv { '/opt/virtualenvs/glitch':
    ensure  => present,
    owner   => 'glitch',
    path    => ['/usr/local/bin', '/usr/bin', '/bin'],
    require => User['glitch'],
  }
}
