class twitch_gmetad::install inherits twitch_gmetad {

  include twitch_gmetad::mgmond

  package { $package_names:
    ensure => 'latest',
  }

  package {'s3cmd':
    provider => 'pip'
  }

  group { 'ganglia':
    ensure => 'present',
  }

  user { 'ganglia':
    ensure           => 'present',
    groups           => 'ganglia',
    home             => '/var/lib/ganglia',
    shell            => '/bin/false',
  }

  $file_defaults = {
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  $files = {
    '/usr/local/ganglia' => {
      ensure => 'link',
      target => "/usr/local/ganglia-${ganglia_version}",
    },
    '/home/ganglia/web' => {
      ensure => 'link',
      target => "/home/ganglia/web-${ganglia_version}",
    },
    '/etc/ganglia' => {
      ensure => 'directory',
    },
    '/usr/local/nginx/conf/ssl' => {
      ensure => 'directory',
      mode   => '0700',
    },
    '/usr/local/ganglia/etc/gmetad.conf' => {
      ensure  => present,
      mode    => '0444',
      content => template("${module_name}/gmetad.conf.erb"),
      require => Package["twitch-ganglia-${ganglia_version}"],
    },
    '/var/lib/ganglia' => {
      ensure  => 'directory',
    },
    '/var/lib/ganglia/rrds' => {
      ensure  => 'directory',
      owner   => 'nobody',
      group   => 'ganglia',
    },
    "/etc/init.d/gmetad" => {
      source => "puppet:///modules/${module_name}/init_d_gmetad",
    },
    "/etc/init/gmetad.conf" => {
      source => "puppet:///modules/${module_name}/init_gmetad.conf",
    },
    "/etc/init/nginx.conf" => {
      source => "puppet:///modules/${module_name}/init_nginx.conf",
      notify  => Class['twitch_nginx'],
    },
    "/etc/init/gmetad.override" => {
      source => "puppet:///modules/${module_name}/init_gmetad.override",
    },
    "/etc/php5/fpm/pool.d/ganglia.conf" => {
      mode => "0644",
      source => "puppet:///modules/${module_name}/fpm_ganglia.conf",
    },
    "/etc/php5/fpm/pool.d/ganglia-socket.conf" => {
      mode => "0644",
      source => "puppet:///modules/${module_name}/fpm_ganglia-socket.conf",
    },
    # configure supervise manually
    '/etc/service' => {
      ensure  => 'directory',
    },
    '/etc/service/ganglia' => {
      ensure  => 'directory',
    },
    '/etc/service/rrdcached' => {
      ensure  => 'directory',
    },
    '/home/ganglia' => {
      ensure  => 'directory',
      owner   => 'ganglia',
      group   => 'ganglia',
    },
    "/etc/service/ganglia/run" => {
      source => "puppet:///modules/${module_name}/run_gmetad",
    },
    "/etc/service/rrdcached/run" => {
      source => "puppet:///modules/${module_name}/run_rrdcached",
    },
    '/var/lib/ganglia-web' => {
      ensure  => 'directory',
      owner   => 'ganglia',
      group   => 'ganglia',
      recurse => true,
    },
    '/var/lib/ganglia-web/dwoo/cache' => {
      ensure  => 'directory',
      owner   => 'nobody',
      require => Package['twitch-ganglia-web2-3.7.2'],
    },
    '/var/lib/ganglia-web/dwoo/compiled' => {
      ensure  => 'directory',
      owner   => 'nobody',
      require => Package['twitch-ganglia-web2-3.7.2'],
    }
  }
  create_resources(file,$files,$file_defaults)
}
