class twitch_gmetad::mgmond (
) inherits twitch_gmetad {

  file { '/etc/gmond':
    ensure => directory,
    owner  => root,
    group  => root,
    mode   => 755,
  }

  service { 'mgmond':
    ensure  => true,
    enable  => true,
    require => [File['/etc/init.d/mgmond'],File['/etc/gmond'],File['/usr/local/sbin/mgmond'],Twitch_gmetad::Gmond[$monitor_cluster],],
  }

  twitch_gmetad::gmond { $monitor_cluster:
    notify => Service[mgmond]
  }

  file { '/etc/init.d/mgmond':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/mgmond-init",
  }

  file { '/usr/local/sbin/mgmond':
    ensure => link,
    target => '/usr/sbin/gmond',
  }
}
