class twitch_gmetad::params {

  $package_names       = ['ganglia-webfrontend',
                          'pkg-config',
                          'libapr1-dev',
                          'libconfuse-dev',
                          'libpcre3-dev',
                          'librrd-dev',
                          'twitch-ganglia-3.7.2',
                          'ganglia-monitor',
                          'twitch-ganglia-web2-3.7.2',
                          'daemontools-run',
                          'rrdcached',
                          'php5-fpm']

  $os_time_zone        = 'US/Pacific'
  $ganglia_version     = '3.7.2'

  $gmond_servers_for_gmetad = $::fqdn ? {
    'ganglia-ec2-1.prod.us-west2.justin.tv' => 'ganglia-ec2-2.prod.us-west2.justin.tv',
    'ganglia-ec2-2.prod.us-west2.justin.tv' => 'ganglia-ec2-3.prod.us-west2.justin.tv',
    'ganglia-ec2-3.prod.us-west2.justin.tv' => 'ganglia-ec2-1.prod.us-west2.justin.tv',
    default                    => '',
  }

  $ganglia_cluster = $::twitch_role ? {
    dbtest          => 'db',
    devdb           => 'dev',
    swift_object    => 'swift',
    swift_container => 'swift',
    swift_proxy     => 'swift',
    'video-pr'      => 'video',
    'video-edge'    => 'video',
    default         => $::twitch_role,
  }

  # don't use ports 8651, 8652, 8659, 8679, 8697, or 8700
  # they're either reserved or used to be other things
  $gmond_port = {
    app                     => 8650,
    unclassified            => 8655,
    db                      => 8656,
    job                     => 8657,
    live                    => 8658,
    mail                    => 8660,
    memcached               => 8661,
    rabbit                  => 8663,
    static                  => 8666,
    stats                   => 8667,
    media                   => 8668,
    telegraph               => 8669,
    usher                   => 8672,
    usherdb                 => 8673,
    video                   => 8674,
    dev                     => 8678,
    discovery               => 8682,
    redis                   => 8683,
    delay                   => 8684,
    mailapp                 => 8686,
    ldap                    => 8687,
    countess                => 8688,
    upload                  => 8689,
    tmi                     => 8690,
    puppet                  => 8693,
    infradb                 => 8694,
    netmon                  => 8696,
    ingest                  => 8698,
    hls                     => 8702,
    jax                     => 8705,
    flowsd                  => 8706,
    find                    => 8708,
    usherweb                => 8709,
    cdncache                => 8710,
    viewcount               => 8712,
    appcache                => 8713,
    aya                     => 8714,
    dbproxy                 => 8715,
    consul                  => 8716,
    scrub                   => 8717,
    audio                   => 8718,
    swift                   => 8719,
    backend_cassandra       => 8720,
    ingest-proxy            => 8721,
    kafka                   => 8722,
    zookeeper               => 8723,
    usher-postgres          => 8724,
    auth-cassandra          => 8725,
    starvation-cassandra    => 8727,
    test-cassandra          => 8728,
    monitor-mtr             => 8729,
    rails-rabbitmq          => 8730,
    rails-memcached         => 8731,
    rails-app               => 8732,
    rails-postgres          => 8733,
    rails-nginx             => 8734,
    rails-varnish           => 8735,
    rails-worker            => 8736,
    shim                    => 8737,
    telegraph-rabbitmq      => 8738,
    virtmaster              => 8739,
    postfix                 => 8740,
    graphite                => 8741,
    statsd                  => 8742,
    nagios                  => 8743,
    ingest-proxy-edge       => 8744,
    owl                     => 8745,
    dns-cache               => 8746,
    dns-hidden              => 8747,
    dns-resolver            => 8748,
    openvpn                 => 8749,
    rails-session-memcached => 8750,
    tmi-redis               => 8751,
    countess-redis          => 8752,
    tmi-postgres            => 8753,
    discovery-postgres      => 8754,
    usher-pgbounce          => 8755,
    nettools-postgres       => 8756,
    postgres-backup         => 8757,
    tmi-haproxy             => 8758,
    video-api               => 8759,
    spectre                 => 8760,
    im-store                => 8761,
    flowmon-influxdb        => 8762,
    presence                => 8763,
    streams-api             => 8764,
    streams-api-varnish     => 8765,
    'tmi-pgbouncer'         => 8766,
    'tmi-postgres-staging'  => 8767,
    'clue'                  => 8768,
    'firehose'              => 8769,
    'friendship'            => 8770,
    'http_edge'             => 8771,
    'irc_edge'              => 8772,
    'pubster'               => 8773,
    'pubsub'                => 8774,
    'room'                  => 8775,
    'tmi_pubsub'            => 8776,
    'transcode'             => 8777,
    'video-tier1'           => 8778,
    rails-ticket-memcached  => 8779,
    video-daemons           => 8800,
    video-cdncache          => 8801,
    pop-master              => 8802,
    trace                   => 8803,
  }
  $monitor_cluster = keys($gmond_port)
}
