class twitch_gmetad::web inherits twitch_gmetad{
  include twitch_nginx

  $nginx_vhost_dir = $twitch_nginx::params::nginx_vhost_dir
  $ldap_server    = hiera('ldap_server')

  $cert_file         = '/usr/local/nginx/conf/ssl/wildcard.internal.justin.tv.crt'
  $key_file          = '/usr/local/nginx/conf/ssl/wildcard.internal.justin.tv.key'
  $wildcard_jtv_cert = 'syseng/ssl_certs/production/wildcard.internal.justin.tv.cert'
  $wildcard_jtv_key  = 'syseng/ssl_keys/production/wildcard.internal.justin.tv.key'

  twitch_sandstorm_agent::template { 'wildcard-jtv-cert':
    destination     => $cert_file,
    key             => $wildcard_jtv_cert,
    restart_command => 'service nginx restart',
  }

  twitch_sandstorm_agent::template { 'wildcard-jtv-key':
    destination     => $key_file,
    key             => $wildcard_jtv_key,
    restart_command => 'service nginx restart',
  }

  file { "${nginx_vhost_dir}/ganglia.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/ganglia-nginx.conf.erb"),
#   notify  => Class['twitch_nginx::service'],
    notify  => Class['twitch_nginx'],
#   require => Class['twitch_nginx::config_dirs'],
  }
}
