class twitch_grafana::config inherits twitch_grafana {

  # Basic Grafana config file
  twitch_sandstorm_agent::template {"grafana.ini":
    destination => '/etc/grafana/grafana.ini',
    contents => template("${module_name}/grafana.ini.erb")
  }

  # AWS credentials for CloudWatch datasources
  file { "/usr/share/grafana/.aws":
    ensure  => 'directory',
    owner   => 'grafana',
    group   => 'grafana',
    mode    => '0700'
  } ->
  twitch_sandstorm_agent::template { "aws_creds":
    destination => '/usr/share/grafana/.aws/credentials',
    contents    => template("${module_name}/aws_credentials.erb"),
    owner       => 'grafana',
    group       => 'grafana',
    mode        => '0600'
  }

  # Vhost to access grafana on port 80
  nginx::resource::vhost { "${server_name}":
    listen_port => 80,
    server_name => ["${server_name}"],
    proxy => "http://127.0.0.1:3000",
    add_header                    => {
      'Strict-Transport-Security' => 'max-age=31536000',
    },
    # Rewrite to HTTPS if using HTTP
    location_raw_prepend => [
      'if ($http_x_forwarded_proto = "http") {',
      'rewrite ^ https://$host$request_uri permanent;',
      '}',
    ],
  }

  # LDAP authentication configuration
  file { '/etc/grafana/ldap.toml':
    ensure  => 'present',
    owner   => 'grafana',
    group   => 'root',
    mode    => '0644',
    content => template("twitch_grafana/ldap.toml.erb"),
    notify  => Service['grafana-server']
  }
}
