class twitch_graphite::config (
  $dns_map = {}
  ) inherits twitch_graphite {

  $config_files = {
    # "${config_dir}/carbon.conf" => {
    #   content => template("${module_name}/carbon.conf.erb")
    # },
    "${config_dir}/storage-schemas.conf" => {
      content => template("${module_name}/storage-schemas.conf.erb")
    },
    "${config_dir}/storage-aggregation.conf" => {
      content => template("${module_name}/storage-aggregation.conf.erb")
    },
    '/etc/go-carbon/go-carbon.conf' => {
      content => template("${module_name}/go-carbon.conf")
    }
    # "/etc/carbon/carbon-c-relay.conf" => {
    #   content => template("${module_name}/carbon-c-relay.conf.erb"),
    # }
  }

  $config_defaults = {
    owner => 'root',
    group => 'root',
    mode  => 0644,
  }

  create_resources(file, $config_files, $config_defaults)

  file{'/etc/cron.daily/metricStats':
    content => template("${module_name}/metricStats.sh.erb"),
    owner   => 'graphite',
    group   => 'graphite',
    mode    => '0755',
    tag     => 'graphite_cron'
  }

  file{'/etc/cron.daily/serverMetricClean':
    content => template("${module_name}/metric_server_clean.sh.erb"),
    owner   => 'graphite',
    group   => 'graphite',
    mode    => '0755',
    tag     => 'graphite_clean'
  }

  # TODO: THIS IS TEMPORARY, REMOVE ONCE DNS IS FIXED (10/22/15)
  create_resources(host, $dns_map)

  # Monitor that go_carbon is running
  twitch_nagios::service {'go_carbon_proc':
    is_nrpe     => true,
    command     => 'check_procs -c 1:1 -C go-carbon',
    description => 'go-carbon Process',
    use         => 'generic-systems-service',
  }

  $num_caches = size($carbon_caches)
  twitch_nagios::service {'carbon_cache_procs':
    ensure      => 'absent',
    is_nrpe     => true,
    command     => "check_procs -a carbon-cache -c ${num_caches}:${num_caches} -C python",
    description => 'Carbon Cache Process Count',
    use         => 'generic-systems-service',
  }

  # Check for carbon-c-relay running
  twitch_nagios::service {'carbon_c_relay_proc':
    ensure      => 'absent',
    is_nrpe     => true,
    command     => 'check_procs -c 1:1 -C carbon-c-relay',
    description => 'Carbon C Relay Process',
    use         => 'generic-systems-service',
  }

  # Check that carbon-c-relay is listening on the right port
  twitch_nagios::service { 'carbon_c_relay_port':
    ensure      => 'absent',
    command     => 'check_tcp!2009',
    description => 'Carbon C Relay Listening Port',
    use         => 'generic-systems-service',
  }

  # go-carbon central syslogging
  $go_carbon_logging = [
    '$ModLoad imfile',
    "\$InputFileName ${graphite_dir}/storage/log/go-carbon.log",
    '$InputFileTag go-carbon:',
    '$InputFileSeverity info',
    '$InputFileFacility local4',
    '$InputRunFileMonitor',
  ]

  rsyslog::snippet { '30-go-carbon':
    ensure  => 'present',
    content => join($go_carbon_logging, "\n"),
  }

  logrotate::rule { 'go_carbon_rotate':
    ensure        => present,
    path          => "${graphite_dir}/storage/log/go-carbon.log",
    missingok     => true,
    rotate        => 3,
    rotate_every  => 'day',
    compress      => true,
    sharedscripts => true,
    create        => false,
    postrotate    => 'service rsyslog reload',
  }
}
