
class twitch_graphite(
  $cluster,
  $webui_enable     = $twitch_graphite::params::webui_enable,
  $max_updates      = $twitch_graphite::params::max_updates,
  $cache_size       = $twitch_graphite::params::cache_size,
  $cpu_count        = $twitch_graphite::params::cpu_count,
  $workers          = $twitch_graphite::params::workers,
  $mount_device     = $twitch_graphite::params::mount_device,
) inherits twitch_graphite::params {

  require twitch_core
  require twitch_monit

  # TEMPORARY FOR GRAPHITE MIGRATION
  if $::lsbdistcodename == 'xenial' {
    validate_bool($webui_enable)

    # Hash containing all cluster info
    $all_clusters = hiera_hash('twitch_graphite_clusters')
    validate_hash($all_clusters)
    if has_key($all_clusters, $cluster) {
      $cluster_servers = $all_clusters[$cluster]
    } else {
      fail("ERROR: Cluster '${cluster}' not found in 'twitch_graphite_clusters'")
    }

    anchor { "${module_name}::start": } ->
    class { "${module_name}::install": } ->
    class { "${module_name}::config": } ->
    class { "${module_name}::service": } ->
    anchor { "${module_name}::end": }

    if $webui_enable {
      Class["${module_name}::install"] ->
      class { "${module_name}::web::install": } ->
      class { "${module_name}::web::config": } ~>
      class { "${module_name}::web::service": } ->
      Anchor["${module_name}::end"]
    }
  }

}
