class twitch_graphite::params {
  $graphite_version = '0.9.15'
  $webui_enable     = true

  $graphite_user    = 'graphite'
  $graphite_group   = 'graphite'

  $graphite_dir     = '/opt/graphite'
  $config_dir       = "${graphite_dir}/conf"
  $http_config_dir  = "${graphite_dir}/webapp/graphite"
  $whisper_dir      = "${graphite_dir}/storage/whisper"
  $whisper_mount    = '/mnt/whisper'
  $log_dir          = '/var/log/graphite-web'
  $db_password      = 'Ih8graphite'

  $max_updates      = 1000
  $cache_size       = 20000000

  $cpu_count        = 8
  $workers          = 8

  $mount_device     = '/dev/xvdb'

  # Name of the cluster.  Override in hiera for additional graphite clusters (e.g. graphite cluster for video)
  $cluster_name = 'general'

  # How many copies should exist for each metric
  $replication_factor = 2
}
