class twitch_graphite::service inherits twitch_graphite {

  if $::lsbdistcodename == 'xenial' {
    file { '/lib/systemd/system/go-carbon.service':
      ensure  => file,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => file("${module_name}/go-carbon.service"),
    } ->
    file { '/lib/systemd/system/buckytools.service':
      ensure  => file,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/buckytools.service.erb"),
    } ->
    file { '/etc/init.d/go-carbon':
      ensure => 'absent',
    } ->
    exec { 'go-carbon reload systemd':
      command     => 'systemctl daemon-reload',
      refreshonly => true,
    }
  }

  service { 'go-carbon':
    ensure    => 'running',
    subscribe => File['/etc/go-carbon/go-carbon.conf']
  }
  service { 'buckytools':
    ensure  => 'running',
    require => File['/lib/systemd/system/buckytools.service']
  }

}
