class twitch_graphite::web::config inherits twitch_graphite {

  file { "${graphite_dir}/storage/log/webapp":
    ensure => 'directory',
    owner  => $graphite_user,
    group  => $graphite_group,
  }

  file { "${graphite_dir}/examples":
    ensure => 'absent',
    force  => true,
  }

  file { "${config_dir}/graphTemplates.conf":
    mode   => '0644',
    owner  => 'root',
    group  => 'root',
    source => "puppet:///modules/${module_name}/graphTemplates.conf",
  }

  file { "${http_config_dir}/local_settings.py":
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/local_settings.py.erb"),
    notify  => Exec['graphite_syncdb'],
  }

  exec { 'graphite_syncdb':
    command     => 'python manage.py syncdb --noinput',
    path        => '/usr/bin',
    cwd         => $http_config_dir,
    refreshonly => true,
  }

  ::rsyslog::snippet { '22-graphite_web':
    content => template("${module_name}/22-graphite_web.conf.erb")
  }

}
