class twitch_graphite::web::install inherits twitch_graphite {

  require postgresql::server
  require postgresql::lib::devel

  require twitch_python::cairo
  require twitch_python::pip::django
  #require twitch_python::pip::django-tagging
  require twitch_python::pip::psycopg2
  require twitch_python::pip::pytz

  include twitch_graphite::cleanup

  postgresql::server::db { 'graphite':
    user     => 'graphite',
    password => postgresql_password('graphite', $db_password),
  }

  package { 'uwsgi': } ->
  package { 'uwsgi-plugin-python': }

  # environment points to where pip installs the package
  ::python::pip { 'graphite-web':
    ensure       => $graphite_version,
    environment  => "PYTHONPATH=${graphite_dir}/webapp",
    install_args => '--install-option="--prefix=/opt/graphite" --install-option="--install-lib=/opt/graphite/webapp"',
    notify       => [
      Class['twitch_graphite::cleanup'],
      Exec['use default graphite.wsgi'],
    ]
  }

  # Need to use 0.3.X of django-tagging, or else setting up
  # graphite web breaks, see: https://github.com/hw-cookbooks/graphite/issues/227
  ::python::pip { 'django-tagging':
    ensure      => '0.3.6',
    environment => "PYTHONPATH=${graphite_dir}/webapp",
  }

  exec { 'use default graphite.wsgi':
    command     => "mv ${config_dir}/graphite.wsgi.example ${config_dir}/graphite.wsgi",
    refreshonly => true,
  }

  # TODO: if number of configuration uwsgi workers becomes a param down the road,
  # the number of processes checked here should be make dynamic
  twitch_nagios::service {'uwsgi_procs':
    is_nrpe     => true,
    command     => 'check_procs -c 9:9 -C uwsgi',
    description => 'Uwsgi Worker Count',
    use         => 'generic-systems-service',
  }

  # Check HTTP
  twitch_nagios::service {'http':
    command     => 'check_http!-P --url=/render', # should hand back a PNG
    description => 'HTTP Graphite-web',
    use         => 'generic-systems-service',
  }

}
