class twitch_graphite::web::service inherits twitch_graphite {

  require twitch_nginx

  #$pidfile = "${graphite_dir}/pids/graphite-web.pid"

  #justsystemdthings
  if $::lsbdistcodename == 'xenial' {
    file { '/lib/systemd/system/graphite-web.service':
      ensure  => file,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/graphite-web.service.erb"),
    }
    service { 'graphite-web':
      ensure => 'running'
    }
  } else {

    twitch_monit::check { 'graphite-web':
      pidfile        => $pidfile,
      cwd            => "${graphite_dir}/lib",
      uid            => 'graphite',
      gid            => 'graphite',
      check_interval => 5,
      command        => "/usr/local/bin/uwsgi --master --socket 127.0.0.1:3031 --wsgi-file=${config_dir}/graphite.wsgi -b 32768 -p 8 --pidfile=${pidfile} --die-on-term --logger syslog:graphite_web,local4 2>&1",
    }
  }

  nginx::resource::vhost { 'graphite.internal.justin.tv':
    listen_port => 80,
    access_log  => '/var/log/nginx/graphite_access.log',
    error_log   => '/var/log/nginx/graphite_error.log',
    add_header  => {
      'Access-Control-Allow-Origin'  => '*',
      'Access-Control-Allow-Methods' => '"GET, OPTIONS"',
      'Access-Control-Allow-Headers' => '"origin, authorization, accept"',
    },
    uwsgi       => '127.0.0.1:3031',
  }
  nginx::resource::location { '/content':
    raw_append     =>  [
                      'expires max;',
                    ],
    location_alias => '/opt/graphite/webapp/content',
    vhost          => 'graphite.internal.justin.tv',
  }

}
