class twitch_graphite_relay::config inherits twitch_graphite_relay {

  file { '/etc/carbon':
    ensure => 'directory',
    owner  => 'carbon',
    group  => 'carbon',
    mode   => '0755',
  } ->
  file { '/etc/carbon/carbon-c-relay.conf':
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/carbon-c-relay.conf.erb"),
    notify  => Service['carbon-c-relay']
  }

  file { '/lib/systemd/system/carbon-c-relay.service':
    ensure  => file,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/carbon-c-relay.service.erb"),
  }

}
