class twitch_graphite_relay (
  $graphite_nodes,
  $graphite_hostname      = $twitch_graphite_relay::params::graphite_hostname,
  $statsd_nodes           = undef,
  $statsd_ports           = undef,
  $graphite_port          = $twitch_graphite_relay::params::graphite_port,
  $enable_statsd_proxy    = $twitch_graphite_relay::params::enable_statsd_proxy,
  $replication_factor     = $twitch_graphite_relay::params::replication_factor,
  $statsd_proxy_workers   = $twitch_graphite_relay::params::statsd_proxy_workers,
  $carbon_c_relay_workers = $twitch_graphite_relay::params::carbon_c_relay_workers,
) inherits twitch_graphite_relay::params {

  require twitch_core

  if $::lsbdistcodename == 'xenial' {
    $clusters = hiera_hash('twitch_graphite_clusters')
    validate_hash($clusters)

    anchor { 'twitch_graphite_relay::start': } ->
    class  { 'twitch_graphite_relay::install': } ->
    class  { 'twitch_graphite_relay::config': } ->
    class  { 'twitch_graphite_relay::service': } ->
    class  { 'twitch_graphite_relay::monitoring': } ->
    anchor { 'twitch_graphite_relay::end': }
  }

}
