class twitch_graphite_relay::install inherits twitch_graphite_relay {

  require twitch_nginx

  group { 'carbon':
    ensure => 'present',
    system => true
  } ->
  user { 'carbon':
    ensure => 'present',
    system => true,
    gid    => $statsd_group,
  } ->
  file { '/var/run/carbon-c-relay':
    ensure => directory,
    owner  => 'carbon',
    group  => 'carbon',
    mode   => '0755',
  }

  package { 'carbon-c-relay': }

  validate_array($graphite_nodes)

  nginx::resource::vhost { $graphite_hostname:
    listen_port          => 80,
    access_log           => '/var/log/nginx/graphite_access.log',
    add_header           => {
      'Access-Control-Allow-Origin'  => '*',
      'Access-Control-Allow-Methods' => '"GET, OPTIONS"',
      'Access-Control-Allow-Headers' => '"origin, authorization, accept"',
    },
    use_default_location => false
  }

  nginx::resource::location { '/':
    proxy => 'http://graphite_web',
    vhost => $graphite_hostname
  }

  nginx::resource::upstream { 'graphite_web':
    members => $graphite_web_upstream,
  }

}
