class twitch_graphite_relay::monitoring inherits twitch_graphite_relay {

  # Make sure the graphite relay is running
  twitch_nagios::service {'carbon-c-relay_proc':
    is_nrpe     => true,
    command     => 'check_procs -c 1:1 -C carbon-c-relay',
    description => 'carbon-c-relay process',
    use         => 'generic-systems-service',
  }

  # Make sure the nginx web proxy is running
  twitch_nagios::service {'check_http':
    ensure      => 'absent',
    is_nrpe     => false,
    command     => 'check_http!-u /render',
    description => 'HTTP check',
    use         => 'generic-systems-service',
  }

  twitch_nagios::service {'graphite_web_http':
    is_nrpe     => false,
    command     => 'check_http!-u /render',
    description => 'HTTP check',
    use         => 'generic-systems-service',
  }

}
