# Expects a list of DNS names and returns an array of IPs it points to
require 'resolv'

module Puppet::Parser::Functions
    newfunction(:dns_lookups, :type => :rvalue) do |args|
        result = []
        dns_names = args[0]
        dns_names.sort.each do |dns_name|
          ips = Resolv.new.getaddresses(dns_name).sort
          result.concat(ips)
        end
        return result.map { |ip| "#{ip}" }
    end
end
