class twitch_graphite_web::config inherits twitch_graphite_web {

  require twitch_nginx

  # Register the node in consul
  consul::service { 'graphite-web':
    tags    => [$::twitch_environment],
  }

  # package { 'codedeploy-agentbuild':
  #   ensure => '0.3.1'
  # }

  $dirs = [
    '/var/run/graphite-web',
    $graphite_dir,
    "${graphite_dir}/conf",
    "${graphite_dir}/storage",
    "${graphite_dir}/storage/log",
    "${graphite_dir}/storage/log/webapp",
  ]

  #$az = "$::ec2_metadata".match(/us-west-2([abc])/)
  if $::ec2_metadata =~ /us-west-2([abc])/ {
    $cluster = $1
  }
  $all_clusters = hiera('twitch_graphite_clusters')
  # Turn cluster FQDNs into IPs
  $cluster_servers = dns_lookups(values($all_clusters[$cluster]))
  validate_array($cluster_servers)

  file { '/etc/uwsgi/apps-enabled/graphite-web.ini':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/graphite-web.ini.erb"),
  }

  file { $dirs:
    ensure => 'directory',
    owner  => $graphite_user,
    group  => $graphite_group,
  }

  file { "${graphite_dir}/examples":
    ensure => 'absent',
    force  => true,
  }

  file { "${config_dir}/graphTemplates.conf":
    mode   => '0644',
    owner  => 'root',
    group  => 'root',
    source => "puppet:///modules/${module_name}/graphTemplates.conf",
  }

  twitch_sandstorm_agent::template { 'local_settings.py':
    destination     => "${http_config_dir}/local_settings.py",
    restart_command => 'service graphite-web restart',
    contents        => template("${module_name}/local_settings.py.erb"),
  }

  exec { 'use default graphite.wsgi':
    command     => "cp ${config_dir}/graphite.wsgi.example ${config_dir}/graphite.wsgi",
    refreshonly => true,
  }

  ::rsyslog::snippet { '22-graphite_web':
    content => template("${module_name}/22-graphite_web.conf.erb")
  }

  # Nagios things
  $nagios_procs = $num_processes + 1
  twitch_nagios::service {'check_uwsgi_procs':
    is_nrpe     => true,
    command     => "check_procs -c ${nagios_procs}:${nagios_procs} -C uwsgi",
    description => 'uwsgi process count',
    use         => 'generic-systems-service',
  }
  twitch_nagios::service {'check_http':
    is_nrpe     => false,
    command     => 'check_http!-u /render',
    description => 'HTTP check',
    use         => 'generic-systems-service',
  }

  # Nginx setup
  nginx::resource::vhost { 'graphite.internal.justin.tv':
    listen_port => 80,
    access_log  => '/var/log/nginx/graphite_access.log',
    error_log   => '/var/log/nginx/graphite_error.log',
    add_header  => {
      'Access-Control-Allow-Origin'  => '*',
      'Access-Control-Allow-Methods' => '"GET, OPTIONS"',
      'Access-Control-Allow-Headers' => '"origin, authorization, accept"',
    },
    uwsgi       => '127.0.0.1:3031',
  }
  nginx::resource::location { '/content':
    raw_append     =>  [
                      'expires max;',
                    ],
    location_alias => '/opt/graphite/webapp/content',
    vhost          => 'graphite.internal.justin.tv',
  }

}
