class twitch_graphite_web::install inherits twitch_graphite_web {

  require postgresql::lib::devel

  require twitch_python::cairo
  require twitch_python::pip::django
  require twitch_python::pip::psycopg2
  #require twitch_python::pip::uwsgi
  require twitch_python::pip::pytz

  package { 'uwsgi': } ->
  package { 'uwsgi-plugin-python': }

  group { $graphite_group:
    ensure => 'present',
    system => true,
    gid    => 978,
  }

  user { $graphite_user:
    ensure  => 'present',
    system  => true,
    gid     => $graphite_group,
    uid     => 978,
    require => Group[$graphite_group]
  }

  ::python::pip { 'whisper':
    ensure  => '0.9.15', # This is just the latest version, not likely to change
  }

  ::python::pip { 'python-memcached':
    ensure => '1.58'
  }

  # environment points to where pip installs the package
  ::python::pip { 'graphite-web-twitch':
    ensure       => $graphite_web_version,
    environment  => "PYTHONPATH=${graphite_dir}/webapp",
    install_args => '--install-option="--prefix=/opt/graphite" --install-option="--install-lib=/opt/graphite/webapp"',
    notify       => [Exec['use default graphite.wsgi'], Service['graphite-web']]
  }

  # Need to use 0.3.X of django-tagging, or else setting up
  # graphite web breaks, see: https://github.com/hw-cookbooks/graphite/issues/227
  ::python::pip { 'django-tagging':
    ensure      => '0.3.6',
    environment => "PYTHONPATH=${graphite_dir}/webapp",
  }

}
