class twitch_graphite_web::service inherits twitch_graphite_web {

  # For when the service file changes
  exec { 'systemctl daemon-reload':
    refreshonly => true
  }

  $pidfile = '/var/run/graphite-web/graphite-web.pid'
  file { '/lib/systemd/system/graphite-web.service':
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/graphite-web.service.erb"),
    notify  => Exec['systemctl daemon-reload'],
  } ->
  service { 'graphite-web':
    ensure => 'running'
  }

}
